 
import numpy as np
from sklearn.datasets import load_boston

from sklearn.linear_model import BayesianRidge
from sklearn.model_selection import train_test_split
from sklearn.metrics import mean_squared_error

import matplotlib.pyplot as plt
from matplotlib.font_manager import FontProperties


# 导入波士顿房价数据，并且切分为训练数据集和测试数据集两部分
boston = load_boston()
x, y = boston.data, boston.target
xtrain, xtest, ytrain, ytest=train_test_split(x, y, test_size=0.15)

# 定义一个贝叶斯岭模型（以默认值）
bay_ridge = BayesianRidge()

# 拟合训练模型
bay_ridge.fit(xtrain, ytrain)

# 计算模型的拟合优度指标
score = bay_ridge.score(xtrain, ytrain)
print("拟合优度(R2): %.2f" % score)

# 对测试数据集进行预测，并计算均方误差指标
ypred = bay_ridge.predict(xtest)
mse = mean_squared_error(ytest, ypred)
print("均方误差MSE: %.2f" % mse)
print("均方根误差RMSE: %.2f" % np.sqrt(mse))

# 可视化展示原始数据和结果
# 获得一个字体对象
font = FontProperties(fname='C:\\Windows\\Fonts\\SimHei.ttf')  #, size=16)

# 设置窗口标题
fig = plt.figure()
fig.canvas.set_window_title('BayesianRidge评估器')

x_ax = range(len(ytest))
plt.scatter(x_ax, ytest, s=5, color="blue", label="原始数据")
plt.plot(x_ax, ypred, lw=0.8, color="red", label="预测数据")
plt.title("BayesianRidge评估器", fontproperties=font)
plt.legend(prop=font)

plt.tight_layout()
plt.show()
 
