 
import numpy as np
from sklearn.datasets import load_iris
from sklearn.model_selection import train_test_split
from sklearn.tree import DecisionTreeClassifier
from sklearn import tree
from matplotlib import pyplot as plt


# 导入系统自带的鸢尾花数据
iris = load_iris()
X = iris.data
y = iris.target

# 划分训练数据集和测试集（自动分配比例）
X_train, X_test, y_train, y_test = train_test_split(X, y, random_state=0)

# 定义并训练决策树分类评估器对象
clf = DecisionTreeClassifier(max_leaf_nodes=3, random_state=0)
clf.fit(X_train, y_train)

score = clf.score(X_test, y_test) #返回预测的准确度
print("平均准确率是：", score)

# 绘制决策树
tree.plot_tree(clf)
# tree.export_text(clf)  # 文本形式输出

plt.show() # 需要调用此方法，才能显示决策树
 
