 
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
from matplotlib.font_manager import FontProperties
from sklearn.tree import DecisionTreeRegressor

#1 导入数据集
dataset = pd.read_csv('Position_Salaries.csv')
X = dataset.iloc[:, 1:2].values  # 返回的类型是二维数组
y = dataset.iloc[:, 2].values

#2 由于数据集样本数不大，所以此例中不再分割。
#  使用默认参数创建决策树回归评估器
regressor = DecisionTreeRegressor(random_state=0)
regressor.fit(X,y)

#3 预测新的数据
y_pred = regressor.predict([[5.5]])

#4 准备绘制图形
plt.figure(figsize=(8, 8))
plt.subplots_adjust(hspace=0.5)
font = FontProperties(fname='C:\\Windows\\Fonts\\SimHei.ttf')  #, size=16)

#4 绘制决策树回归结果
plt.subplot(2, 1, 1)

plt.scatter(X, y, color = 'red')
plt.plot(X, regressor.predict(X), color = 'blue')
plt.title('决策树回归结果', fontproperties=font)
plt.xlabel('职务级别', fontproperties=font)
plt.ylabel('薪水', fontproperties=font)

#5 绘制决策树回归结果（精度更高）
plt.subplot(2, 1, 2)

X_grid = np.arange(min(X), max(X), 0.01)
X_grid = X_grid.reshape((len(X_grid), 1))

plt.scatter(X, y, color = 'red')
plt.plot(X_grid, regressor.predict(X_grid), color = 'blue')
plt.title('决策树回归结果(精度更高)', fontproperties=font)
plt.xlabel('职务级别', fontproperties=font)
plt.ylabel('薪水', fontproperties=font)

plt.show()
 
