 
import numpy as np
from sklearn.datasets import load_boston
from sklearn.linear_model import ElasticNet,ElasticNetCV
from sklearn.metrics import mean_squared_error
from sklearn.model_selection import train_test_split
import matplotlib.pyplot as plt
from matplotlib.font_manager import FontProperties

boston = load_boston()
x, y = boston.data, boston.target
xtrain, xtest, ytrain, ytest = train_test_split(x, y, test_size=0.15)

alphas = [0.0001, 0.001, 0.01, 0.1, 0.3, 0.5, 0.7, 1]
elastic_cv = ElasticNetCV(alphas=alphas, cv=5)
model = elastic_cv.fit(xtrain, ytrain)

print(model)
print('-'*27)
print('最佳正则化系数α：', model.alpha_)
print('模型截距：', model.intercept_)

# 预测并计算各种指标
ypred = model.predict(xtest)
score = model.score(xtest, ytest)
mse = mean_squared_error(ytest, ypred)
print("R2:{0:.3f}, MSE:{1:.2f}, RMSE:{2:.2f}"
      .format(score, mse, np.sqrt(mse)))


# 信息可视化
plt.figure()

# 通过这种方式可以局部设置字体（支持中文），不影响绘图其他部分
font = FontProperties(fname='C:\\Windows\\Fonts\\SimHei.ttf')  # , size=16

x_ax = range(len(xtest))
plt.scatter(x_ax, ytest, s=5, color="blue", label="观测值")
plt.plot(x_ax, ypred, lw=0.8, color="red",  label="预测值")
plt.legend(prop = font)
plt.show()
 
