 
from sklearn.datasets import load_iris
from sklearn.model_selection import train_test_split
from sklearn.naive_bayes import GaussianNB
from sklearn import metrics


# 导入系统自带的鸢尾花数据集
iris = load_iris()
X = iris.data
y = iris.target

# 划分训练数据集和测试集
X_train, X_test, y_train, y_test = train_test_split(X,y,test_size=0.2,random_state=0)

# 声明一个高斯朴素贝叶斯分类评估器，并拟合
model = GaussianNB()
model.fit(X_train, y_train)

# 进行预测
expected = y_test
predicted = model.predict(X_test)

# 显示各种性能指标
print("分类报告：") 
print(metrics.classification_report(expected, predicted))
print("-"*37)
print("混淆矩阵：")
print(metrics.confusion_matrix(expected, predicted))
 
