 
from sklearn.datasets import make_classification
from sklearn.gaussian_process import GaussianProcessClassifier

# 使用make_classification()函数生成分类数据
# 特征变量数量：20个；样本数量：100个；目标类别数量：2个（使用默认值n_classes=2）
X, y = make_classification(n_samples=100, n_features=20, n_informative=15,
                           n_redundant=5, random_state=1)

# 定义模型
gpclf = GaussianProcessClassifier()

# 拟合模型
gpclf.fit(X, y)

# 定义一个20维的新数据
row = [2.47475454,  0.40165523, 1.68081787,  2.88940715,  0.91704519, -3.07950644,
       4.39961206,  0.72464273, -4.86563631, -6.06338084, -1.22209949, -0.4699618,
       1.01222748,  -0.6899355, -0.53000581, 6.86966784, -3.27211075, -6.59044146,
       -2.21290585, -3.139579]

# 预测
yhat = gpclf.predict([row])

# 预测分类标签
print('Predicted Class: %d' % yhat)
 
