 
import numpy as np
from sklearn.gaussian_process.kernels import RBF
from sklearn.gaussian_process import GaussianProcessRegressor
from matplotlib import pyplot as plt
from matplotlib.font_manager import FontProperties

#1 构建高斯过程回归对象
kernel = 1.0 * RBF(length_scale=1.0, length_scale_bounds=(1e-1, 10.0))
gp = GaussianProcessRegressor(kernel=kernel)

#2 准备绘制图形
plt.figure(figsize=(8, 8))
plt.subplots_adjust(hspace=0.6)
font = FontProperties(fname='C:\\Windows\\Fonts\\SimHei.ttf')  #, size=16)

# 3 绘制先验图形（GP prior），此时无需事先调用fit()函数
plt.subplot(2, 1, 1)

X_ = np.linspace(0, 5, 100)
y_mean, y_std = gp.predict(X_[:, np.newaxis], return_std=True)

plt.plot(X_, y_mean, 'k', lw=3, zorder=9)
plt.fill_between(X_, y_mean - y_std, y_mean + y_std,
                 alpha=0.2, color='k')
y_samples = gp.sample_y(X_[:, np.newaxis], 10)
plt.plot(X_, y_samples, lw=1)

plt.xlim(0, 5)
plt.ylim(-3, 3)
plt.title("先验(kernel:  %s)" % kernel, fontsize=12, fontproperties=font)

# 4 生成训练数据，并使用这些数据进行模拟
rng = np.random.RandomState(4)
X = rng.uniform(0, 5, 10)[:, np.newaxis]
y = np.sin((X[:, 0] - 2.5) ** 2)
gp.fit(X, y)

# 5 绘制后验图形（Plot posterior），需事先调用fit()函数
plt.subplot(2, 1, 2)

X_ = np.linspace(0, 5, 100)
y_mean, y_std = gp.predict(X_[:, np.newaxis], return_std=True)

plt.plot(X_, y_mean, 'k', lw=3, zorder=9)
plt.fill_between(X_, y_mean - y_std, y_mean + y_std,
                 alpha=0.2, color='k')

y_samples = gp.sample_y(X_[:, np.newaxis], 10)
plt.plot(X_, y_samples, lw=1)
plt.scatter(X[:, 0], y, c='r', s=50, zorder=10, edgecolors=(0, 0, 0))

plt.xlim(0, 5)
plt.ylim(-3, 3)
plt.title("后验(kernel: %s)\n Log-Likelihood: %.3f"
          % (gp.kernel_, gp.log_marginal_likelihood(gp.kernel_.theta)),
          fontsize=12, fontproperties=font)
plt.tight_layout()

plt.show()
