import numpy as np
from sklearn.model_selection import GroupKFold
X = np.array([[1, 2], [3, 4], [5, 6], [7, 8]])
y = np.array([1, 2, 3, 4])

groups = np.array([0, 0, 2, 2])
group_kfold = GroupKFold(n_splits=2)
kk = group_kfold.get_n_splits(X, y, groups)
print(kk, "\n\n\n")

for train_index, test_index in group_kfold.split(X, y, groups):
    print("TRAIN:", train_index, "TEST:", test_index)
    X_train, X_test = X[train_index], X[test_index]
    y_train, y_test = y[train_index], y[test_index]
    print("X_train:" , X_train)
    print("X_test:" , X_test)
    print("y_train:" , y_train)
    print("y_test:" , y_test)
    print("---------------")
