 
from sklearn.datasets import make_regression
from sklearn.isotonic import IsotonicRegression

X, y = make_regression(n_samples=10, n_features=1, random_state=41)
X = X.ravel() # 转换为 1维数组, sklearn 0.24版本将支持一个特征变量的2维数组
print("特征变量的取值范围：[%f, %f]" % (X.min(), X.max()))
X1 = [0.1, 0.2, 0.78, 0.9]
print("待预测特征变量值  :", X1)
print("-"*37, "\n")

#1 使用默认构造函数参数，创建保序回归模型，并拟合
print("1 保序回归模型（out_of_bounds='nan'）")
iso_reg = IsotonicRegression().fit(X, y)
print("目标变量各区间开始，结束范围:")
print(iso_reg.y_thresholds_)
prdct = iso_reg.predict(X1)
print("目标变量的预测值为：")
print(prdct)

print("\n", "*"*37, "\n")

print("2 保序回归模型（out_of_bounds='clip'）")
iso_reg = IsotonicRegression(out_of_bounds='clip').fit(X, y)
print("目标变量各区间开始，结束范围:")
print(iso_reg.y_thresholds_)

prdct = iso_reg.predict(X1)
print("目标变量的预测值为：")
print(prdct)
 
