 
import numpy as np
import pandas as pd
from sklearn.datasets import make_blobs
from sklearn.cluster import KMeans
import matplotlib.pyplot as plt
from matplotlib.font_manager import FontProperties


#1 使用make_blobs()生成聚类所需的样本数据集
X, y = make_blobs(n_samples=300, centers=4, cluster_std=0.60, random_state=0)

#2 根据生成的样本数据集，进行聚类运算。
wcss = []   # Within-Cluster-Sum-of-Squares（inertia）
for i in range(1, 11):
    kmeans = KMeans(n_clusters=i, init='k-means++', max_iter=300, n_init=10, random_state=0)
    kmeans.fit(X)
    wcss.append(kmeans.inertia_)
# end of for loop


### 构建一个字体对象，以使pyplot支持中文
font = FontProperties(fname='C:\\Windows\\Fonts\\SimHei.ttf')  #, size=16)

#3 创建子图，并设置shareX, shareY为False,表示不共享x,y轴
fig, axes = plt.subplots(nrows=2, ncols=1, figsize=(10, 10), sharex=False, sharey=False)
fig.canvas.set_window_title("KMeans聚类")

#4 绘制惯性（inertia）随簇数量变化的曲线
axes[0].set_ylim([0,max(wcss)])
axes[0].plot(range(1, 11), wcss)
axes[0].set_title("惯性随簇数量变化曲线", fontproperties=font)

#5 以K=4可视化聚类结果（实际上，4是最优的簇数量）
kmeans = KMeans(n_clusters=4, init='k-means++', max_iter=300, n_init=10, random_state=0)
pred_y = kmeans.fit_predict(X)

axes[1].set_ylim( [0, X.max()] )
axes[1].scatter( X[:,0], X[:,1])
denters = kmeans.cluster_centers_
axes[1].scatter(denters[:, 0], denters[:, 1], s=100, c='red', label='K=4')
axes[1].legend(loc='upper right', prop=font)
axes[1].set_title("K=4聚类结果", fontproperties=font)

plt.show()
 
