 
import numpy as np
from sklearn import datasets
from sklearn.model_selection import train_test_split
from sklearn.preprocessing import StandardScaler
from sklearn.neighbors import KNeighborsClassifier
from sklearn.metrics import classification_report, confusion_matrix

#1. 使用系统自带的鸢尾花数据集
iris = datasets.load_iris()
X = iris.data    # 特征变量  
y = iris.target  # 目标变量
 
#2. 划分训练数据集和测试数据集  
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size = 0.3, random_state=12345)  

#3. 对数据进行规范化处理，消除不同特别变量量纲的影响
scaler = StandardScaler()
scaler.fit(X_train)

X_train = scaler.transform(X_train)
X_test = scaler.transform(X_test)

#4. 定义KNeighborsClassifier对象，并进行训练（拟合）
classifier = KNeighborsClassifier(n_neighbors=25)
classifier.fit(X_train, y_train)

#5. 对X_test进行预测处理
y_pred = classifier.predict(X_test)

#6. 验证算法的性能
print("混淆矩阵：")
print(confusion_matrix(y_test, y_pred))
print("-"*37)
print("分类报告：")
print(classification_report(y_test, y_pred))
 
