 
import numpy as np
import matplotlib.pyplot as plt
from sklearn import neighbors
from matplotlib.font_manager import FontProperties

# 初始化随机数种子
np.random.seed(0)

# 初始特征变量数据集(X)，40个数据点(40X1)
X0 = 5 * np.random.rand(40, 1)
# 将指定轴上的元素按照从小到大的顺序排列
X = np.sort(X0, axis=0)

# 生成目标变量数据集
y = np.sin(X).ravel()
# 每隔5个元素，添加随机误差[start:end:step]
y[::5] += 1 * (0.5 - np.random.rand(8))

# 待预测的特征变量数据集
# linspace(start, stop, num)，返回均匀间隔的数据
T = np.linspace(0, 5, 500)[:, np.newaxis]


# ########################################################################
# 拟合K最近邻回归模型
# 获得一个字体对象
font = FontProperties(fname='C:\\Windows\\Fonts\\SimHei.ttf')  #, size=16)

fig = plt.figure()
fig.canvas.set_window_title('KNeighborsRegressor评估器')

n_neighbors = 5
for i, weights in enumerate(['uniform', 'distance']):
    knn = neighbors.KNeighborsRegressor(n_neighbors, weights=weights)
    y_ = knn.fit(X, y).predict(T)

    plt.subplot(2, 1, i + 1)
    plt.scatter(X, y, color='darkorange', label='原始数据')
    plt.plot(T, y_, color='navy', label='预测值')
    plt.axis('tight')
    plt.legend(prop=font)
    plt.title("KNeighborsRegressor (k = %i, weights = '%s')" % (n_neighbors,
                                                                weights))
plt.tight_layout()
plt.show()
 
