 
import numpy as np
from sklearn import datasets
from sklearn.semi_supervised import LabelPropagation

# 使用系统自带的鸢尾花数据集
iris = datasets.load_iris()

rng = np.random.RandomState(42)
# 构建一个布尔数组
random_unlabeled_points = rng.rand(len(iris.target)) < 0.3

# 目标变量
labels = np.copy(iris.target)
# 故意设置一些样本为无标签样本数据（目标变量设置为-1）
labels[random_unlabeled_points] = -1


# 定义并训练标签传播评估器对象
label_prop_model = LabelPropagation()
label_prop_model.fit(iris.data, labels)

# 输出标签信息
print("标签类别有 %d 个，分别是 %s。" %
      (len(label_prop_model.classes_), label_prop_model.classes_))
print("----------------------------------------------")
print("展示前10个样本的输出概率（每个类别标签）")
prob = label_prop_model.predict_proba(iris.data)
print(prob[:10,:])
 
