 
from numpy import sqrt
from sklearn import linear_model
from sklearn.datasets import load_boston
from sklearn.model_selection import train_test_split
from sklearn.metrics import mean_squared_error
from matplotlib.font_manager import FontProperties
import matplotlib.pyplot as plt


# 使用Python系统自带的波士顿房价数据
boston = load_boston()
x, y = boston.data, boston.target

# 划分训练集和测试集
xtrain, xtest, ytrain, ytest=train_test_split(x, y, test_size=0.15)

# 创建最小角Lasso回归模型
lassolars = linear_model.LassoLars(alpha =.1).fit(xtrain, ytrain)
print(lassolars) 
print(lassolars.coef_)
print()

# 预测新数据，并计算度量指标
ypred = lassolars.predict(xtest)
mse = mean_squared_error(ytest, ypred)
print("MSE: %.2f" % mse)
print("RMSE: %.2f" % sqrt(mse))

# 显示预测曲线
font = FontProperties(fname='C:\\Windows\\Fonts\\SimHei.ttf')  # , size=16

x_ax = range(len(ytest))
plt.scatter(x_ax, ytest, s=5, color="blue", label="原始值")
plt.plot(x_ax, ypred, lw=0.8, color="red",  label="预测值")
plt.legend(prop = font)
plt.show()
 
