 
import numpy as np
from sklearn import datasets
from sklearn.linear_model import LassoLarsIC
import matplotlib.pyplot as plt
from matplotlib.font_manager import FontProperties

X, y = datasets.load_diabetes(return_X_y=True)

rng = np.random.RandomState(42)
X = np.c_[X, rng.randn(X.shape[0], 14)]  # add some bad features

# 对数据进行归一化处理
X /= np.sqrt(np.sum(X ** 2, axis=0))

# 阿卡克信息标准AIC的Lasso模型
model_aic = LassoLarsIC(criterion='aic')
model_aic.fit(X, y)
alpha_aic_ = model_aic.alpha_

# 贝叶斯信息标准BIC的Lasso模型
model_bic = LassoLarsIC(criterion='bic')
model_bic.fit(X, y)
alpha_bic_ = model_bic.alpha_

# 定义基于信息准则的Lasso回归模型信息的可视化输出
# 定义一个很小的常量，避免取对数比例时出现零除问题
EPSILON = 1e-4
def plot_ic_criterion(model, name, color):
    criterion_ = model.criterion_
    plt.semilogx(model.alphas_ + EPSILON, criterion_, '--', color=color,
                 linewidth=3, label='%s 准则' % name)
    plt.axvline(model.alpha_ + EPSILON, color=color, linewidth=3,
                label='alpha: %s 估计' % name)
    plt.xlabel('α')
    plt.ylabel('信息准则(AIC/BIC)', fontproperties=font)


# 信息可视化
plt.figure()

# 通过这种方式可以局部设置字体（支持中文），不影响绘图其他部分
font = FontProperties(fname='C:\\Windows\\Fonts\\SimHei.ttf')  # , size=16

plot_ic_criterion(model_aic, 'AIC', 'b')
plot_ic_criterion(model_bic, 'BIC', 'r')
plt.legend(prop = font)
plt.title('基于信息准则的模型选择', fontproperties=font)

plt.show()
 
