 
import numpy as np
from sklearn import datasets
from sklearn.linear_model import lasso_path
from matplotlib import pyplot as plt
from matplotlib.font_manager import FontProperties

# 导入系统自带的糖尿病数据集
X, y = datasets.load_diabetes( return_X_y = True )
print("X数据集的形状", X.shape)

# 数据预处理 -- 标准化
#X /= X.std(axis=0)

# eps越小，路径会越长
eps = 5e-3

# 计算路径信息
print("计算Lasso路径......")
alphas_0, coefs_0, _ = lasso_path(X, y, eps=eps, fit_intercept=False)

print("计算正Lasso路径......")
alphas_1, coefs_1, _ = lasso_path(X, y, eps=eps, positive=True, fit_intercept=False)


# 显示结果
plt.figure()

# 为了显示清楚，对α进行对数处理（不影响顺序）
log_alphas_0 = np.log10(alphas_0)
log_alphas_1 = np.log10(alphas_1)
for coef_0, coef_l in zip(coefs_0, coefs_1):
    l0 = plt.plot(log_alphas_0, coef_0)
    l1 = plt.plot(log_alphas_1, coef_l, linestyle='--')

# 通过这种方式可以局部设置字体（支持中文），不影响绘图其他部分
font = FontProperties(fname='C:\\Windows\\Fonts\\SimHei.ttf')  # , size=16
plt.xlabel('Log(α)')
plt.ylabel('回归系数', fontproperties=font)
plt.title('Lasso/正Lasso的回归系数与正则化系数α的关系', fontproperties=font, fontsize=16)
plt.legend((l0[-1], l1[-1]), ('Lasso', '正Lasso'), loc='best', prop = font)

plt.axis('tight')

plt.show()
