
import numpy as np
from sklearn import datasets
from sklearn import linear_model
from sklearn.model_selection import train_test_split
import sklearn.metrics as metrics


# 导入糖尿病数据
#diabetes_X, diabetes_y = datasets.load_diabetes(return_X_y=True)
# 返回一个 Bunch 对象，目的是获取特征名称名称feature_names
diabetes_Bunch = datasets.load_diabetes()
diabetes_X = diabetes_Bunch.data
diabetes_y = diabetes_Bunch.target
X_NameList = diabetes_Bunch.feature_names

X_train, X_test, y_train, y_test = train_test_split(diabetes_X, diabetes_y, test_size=0.33, random_state=42)
# 创建一般线性回归模型
olsRegr = linear_model.LinearRegression()

# 使用训练数据进行模型拟合
olsRegr.fit(X_train, y_train)
print(olsRegr)
print("--------------------------------------")
# 使用拟合后的模型进行预测
y_pred = olsRegr.predict(X_test)


# 截距和回归系数
print("截    距：%f" % olsRegr.intercept_)

print("特征变量及其回归系数：")
# 模型按照特征变量的输入顺序返回每个特征变量的回归系数
X_Number   = len(X_NameList)  # 变量个数
olsCoefs   = olsRegr.coef_
for i in range(X_Number):
    print("%2d  %3s: %+f" % (i+1, X_NameList[i], olsCoefs[i]))


# 线性模型的各种度量指标
print("\n最小二乘法模型的各种度量指标：")
print("--------------------------------------")
# 最大残差
print("        最大残差: %f" % metrics.max_error(y_test, y_pred))

# 可解释方差
print("      可解释方差: %f" % metrics.explained_variance_score(y_test, y_pred))

# 均方误差MSE
print("     均方误差MSE: %f" % metrics.mean_squared_error(y_test, y_pred))

# 中位数绝对误差
print("  中位数绝对误差: %f" % metrics.median_absolute_error(y_test, y_pred))

# 平均绝对误差MAE
print(" 平均绝对误差MAE: %f" % metrics.mean_absolute_error(y_test, y_pred))

# 均方对数误差MSLE
print("均方对数误差MSLE: %f" % metrics.mean_squared_log_error(y_test, y_pred))

# 拟合优度R^2（决定系数）
print("        拟合优度: %f" % metrics.r2_score(y_test, y_pred))

