 
from sklearn.datasets import load_iris
from sklearn.model_selection import train_test_split
from sklearn.preprocessing import StandardScaler
from sklearn.neural_network import MLPClassifier
from sklearn.metrics import plot_confusion_matrix
from matplotlib.font_manager import FontProperties
import matplotlib.pyplot as plt


#1. 导入系统自带的鸢尾花数据集  
iris = load_iris()  
X = iris.data  
y = iris.target

#2. 预留20%的数据，用于测试模型的准确性
X_train, X_test, y_train, y_test = train_test_split(X,y,random_state=1, test_size=0.2)

#3. 对训练数据集和测试数据集进行标准化转换，目标：中心化（0均值）、
#   特征变量具有相同数量集的方差
sc_X = StandardScaler()
X_trainscaled = sc_X.fit_transform(X_train)
X_testscaled  = sc_X.transform(X_test)

#4. 定义感知机分类评估器，并训练 
#   这是一个6层神经网络（包括输入层和输出层），其中四层隐藏层
#   隐藏层中神经元的数量分别是256,128,64,32，使用了默认的求解器“Adam”
clf = MLPClassifier(hidden_layer_sizes=(256, 128, 64, 32),activation="relu",random_state=1) \
               .fit(X_trainscaled, y_train)
y_pred=clf.predict(X_testscaled)
score = clf.score(X_testscaled, y_test)  # 模型评分

#5. 绘制混淆矩阵，可视化
#   首先创建一个中文字体对象  
font = FontProperties(fname='C:\\Windows\\Fonts\\SimHei.ttf')  #, size=16)

fig = plot_confusion_matrix(clf, X_testscaled, y_test, display_labels=["Setosa","Versicolor","Virginica"])
fig.figure_.suptitle("混淆矩阵(准确率：" + str(score) + ")", fontproperties=font)

plt.show()
 
