 
import numpy as np
from sklearn.neural_network import MLPRegressor
import matplotlib.pyplot as plt
from matplotlib.font_manager import FontProperties


#1 构造训练数据集
x = np.arange(0.0, 1, 0.01).reshape(-1, 1)
y = np.sin(2 * np.pi * x).ravel()

#2 创建多层感知器
mlp_reg = MLPRegressor( hidden_layer_sizes=(10,), activation='logistic',
               solver='lbfgs', alpha=0.001, learning_rate_init=0.01, max_iter=1000 )

#3 拟合、构造模型
mlp_reg.fit(x, y)

#4 构造测试数据集，并预测
test_x = np.arange(0.0, 1, 0.05).reshape(-1, 1)
test_y = mlp_reg.predict(test_x)

#5 绘制图形
#4 准备绘制图形
plt.figure()
font = FontProperties(fname='C:\\Windows\\Fonts\\SimHei.ttf')  #, size=16)

plt.scatter(x, y, s=20, c='b', marker="x", label='真实值')
plt.scatter(test_x,test_y, s=10, c='r', marker="o", label='预测值')
plt.title('多层感知器回归结果', fontproperties=font)
plt.xlabel('X', fontproperties=font)
plt.ylabel('Y', fontproperties=font)
plt.legend(prop=font)

plt.show()
 
