 
import numpy as np
from sklearn.datasets import make_sparse_coded_signal
import matplotlib.pyplot as plt
from matplotlib.font_manager import FontProperties
from sklearn.linear_model import OrthogonalMatchingPursuit
from sklearn.linear_model import OrthogonalMatchingPursuitCV


n_components, n_features = 512, 100
n_nonzero_coefs = 17

# 生成“干净”的数据：有多个已知成分组成的稀疏信号
# y = Xw
# |x|_0 = n_nonzero_coefs
y, X, w = make_sparse_coded_signal(n_samples=1,
                                   n_components=n_components,
                                   n_features=n_features,
                                   n_nonzero_coefs=n_nonzero_coefs,
                                   random_state=0)

idx, = w.nonzero()

# 对“干净”信息施加噪声信号
y_noisy = y + 0.05 * np.random.randn(len(y))

# 绘制稀疏信号
# 通过这种方式可以局部设置字体（支持中文），不影响绘图其他部分
font = FontProperties(fname='C:\\Windows\\Fonts\\SimHei.ttf')  # , size=16

plt.figure(figsize=(7, 7))
plt.subplot(4, 1, 1)
plt.xlim(0, 512)
plt.title("稀疏信号", fontproperties=font)
plt.stem(idx, w[idx], use_line_collection=True)

# 从无噪声观测信号中恢复原始信号
omp = OrthogonalMatchingPursuit(n_nonzero_coefs=n_nonzero_coefs)
omp.fit(X, y)
coef = omp.coef_
idx_r, = coef.nonzero()
plt.subplot(4, 1, 2)
plt.xlim(0, 512)
plt.title("从无噪声观测信号中恢复原始信号", fontproperties=font)
plt.stem(idx_r, coef[idx_r], use_line_collection=True)

# 从有噪声观测信号中恢复原始信号
omp.fit(X, y_noisy)
coef = omp.coef_
idx_r, = coef.nonzero()
plt.subplot(4, 1, 3)
plt.xlim(0, 512)
plt.title("从有噪声观测信号中恢复原始信号", fontproperties=font)
plt.stem(idx_r, coef[idx_r], use_line_collection=True)

# 使用交叉验证正交匹配追踪法
omp_cv = OrthogonalMatchingPursuitCV()
omp_cv.fit(X, y_noisy)
coef = omp_cv.coef_
idx_r, = coef.nonzero()
plt.subplot(4, 1, 4)
plt.xlim(0, 512)
plt.title("从有噪声观测信号中恢复原始信号（交叉验证）", fontproperties=font)
plt.stem(idx_r, coef[idx_r], use_line_collection=True)

plt.subplots_adjust(0.06, 0.04, 0.94, 0.90, 0.20, 0.38)
plt.suptitle('使用正交匹配追踪法OMP对稀疏信号进行复原', fontsize=16, fontproperties=font)
plt.show()
 
