 
import numpy as np 
from sklearn.datasets import make_regression
from sklearn.linear_model import LinearRegression
from sklearn.linear_model import PassiveAggressiveRegressor
from matplotlib.font_manager import FontProperties
import matplotlib.pyplot as plt


# 生成回归样本数据集
n_samples, n_features = 2000, 3
X, y, w = make_regression(n_samples=n_samples, n_features=n_features, random_state=42, coef=True, noise=1.0)

# 使用LinearRegression模型（批处理形式）
batch_acc = np.zeros((n_samples, 1))
lm_rgr = LinearRegression()
lm_rgr.fit(X, y)
batch_acc.fill( np.abs(lm_rgr.predict(X) - y).sum() )


# 逐步学习（在线学习）形式（PassiveAggressiveRegressor）
pa_rgr = PassiveAggressiveRegressor()
pa_acc = np.zeros((n_samples, 1))
coefs = np.zeros((n_samples, n_features))
for i, x in enumerate(X):
    pa_rgr.partial_fit([x], [y[i]])

    # error
    pa_acc[i,:]= np.abs(pa_rgr.predict(X) - y).sum()
    # coef
    coefs[i,:] = pa_rgr.coef_


# 获得一个字体对象
font = FontProperties(fname='C:\\Windows\\Fonts\\SimHei.ttf')  # , size=16

# 设置图像标题，默认为"Figure 1"
fig = plt.figure("PassiveAggressiveRegressor")
# 调整边距和子图的间距
fig.subplots_adjust(hspace=0.5)

#子图1 绘制每个特征变量的回归系数变化趋势
ax1 = fig.add_subplot(211)
ax1.plot(range(n_samples), coefs[:,0], "-b", label="特征变量1")
ax1.plot(range(n_samples), coefs[:,1], "-r", label="特征变量2")
ax1.plot(range(n_samples), coefs[:,2], "-g", label="特征变量3")


# 设置其它组件 -- x,y坐标轴文字以及Title和图例
ax1.set_xlabel("样本序号", fontproperties=font)
ax1.set_ylabel("回归系数", fontproperties=font)
ax1.set_title("逐样本回归系数变化(被动攻击回归模型)", fontproperties=font)
ax1.legend(loc='best',fancybox=True, shadow=True, prop=font)


#子图2 绘制两种模型误差的变化趋势
ax2 = fig.add_subplot(212)
ax2.plot(range(n_samples), batch_acc, "-b", label="批处理结果")
ax2.plot(range(n_samples), pa_acc,    "-r", label="逐步处理结果")

# 设置其它组件 -- x,y坐标轴文字以及Title和图例
ax2.set_xlabel("样本序号", fontproperties=font)
ax2.set_ylabel("误差", fontproperties=font)
ax2.set_title("\n\n逐样本误差变化", fontproperties=font)
ax2.legend(loc='best',fancybox=True, shadow=True, prop=font)

plt.axis('tight')
plt.show()
 
