 
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.font_manager import FontProperties

from sklearn.linear_model import Ridge
from sklearn.preprocessing import PolynomialFeatures
from sklearn.pipeline import make_pipeline


# f(x) ：关联X和Y
def f(x):
    return x * np.sin(x)


# 生成绘制图形所需要的数据（X轴）
x_plot = np.linspace(0, 10, 100)

# 生成绘图点对，并取其一个子集
x0 = np.linspace(0, 10, 100)
rng = np.random.RandomState(0)
rng.shuffle(x0)   # 随机洗牌（打乱顺序）

# 取得一个子集：获取前20个数据，并排序
x = np.sort(x0[:20])
y = f(x)  # 通过给定函数处理

# create matrix versions of these arrays
X = x[:, np.newaxis]
X_plot = x_plot[:, np.newaxis]


# 绘图
plt.figure('PolynomialFeatures')
# 获得一个字体对象
font = FontProperties(fname='C:\\Windows\\Fonts\\SimHei.ttf')  # , size=16


plt.plot(x_plot, f(x_plot), color='cornflowerblue', linewidth=2,
         label="真实曲线")
plt.scatter(x, y, color='navy', s=30, marker='o', label="训练样本点")

# 下面展示不同次数的多项式回归的效果
colors = ['teal', 'yellowgreen', 'red']
for count, degree in enumerate([3, 4, 5]):
    #1 定义多项式特征变量对象
    poly = PolynomialFeatures(degree=degree)
    #2 对原始特征变量进行转换，生成多项式特征变量集
    X_new = poly.fit_transform(X)
    #3 使转换后的特征变量集应用于一个回归模型（这里是岭回归）
    #  并拟合模型
    model = Ridge().fit(X_new, y)
    #4 为了适合模型进行预测，转换X_plot，以便符合岭回归模型
    X_plot_new = poly.fit_transform(X_plot)
    #5 使用拟合后的模型对新数据进行预测，获得预测值
    y_plot = model.predict(X_plot_new)

    #6 最后使用预测后的数据进行曲线绘制，以便对比
    plt.plot(X_plot, y_plot, color=colors[count], linewidth=2,
             label="%d 次多项式" % degree)

plt.title("线性多项式回归拟合非线性问题", fontproperties=font)
plt.xlabel("X")
plt.ylabel("y")
plt.legend(loc='lower left', prop=font)

plt.show()
 
