 
from sklearn import datasets
from sklearn.linear_model import RidgeClassifier
from sklearn.model_selection import train_test_split
from sklearn.metrics import plot_precision_recall_curve
from matplotlib.font_manager import FontProperties
import matplotlib.pyplot as plt


# 导入系统自带数据
dataset = datasets.load_breast_cancer()
X = dataset.data    # 特征变量
y = dataset.target  # 目标变量

# 划分训练数据集和测试数据集
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size = 0.3, random_state=12345)

# 定义一个岭分类评估器对象，并使用训练书籍进行拟合
ridgeClf = RidgeClassifier()
ridgeClf.fit(X_train, y_train)

# 创建一个中文字体对象
font = FontProperties(fname='C:\\Windows\\Fonts\\SimHei.ttf')  #, size=16)

# 绘制召回率(recall)-查准率(precision)曲线
disp = plot_precision_recall_curve(ridgeClf, X_test, y_test)
disp.ax_.set_title("二分类召回率(recall) -- 查准率(precision)关系图", fontproperties=font)
# 显示
plt.show()
 
