 
import numpy as np
from sklearn import linear_model
from sklearn.model_selection import train_test_split
import matplotlib.pyplot as plt
from matplotlib.font_manager import FontProperties


# 构建数据集，一个 20x20 希尔伯特Hilbert矩阵
X = 1. / (np.arange(1, 21) + np.arange(0, 20)[:, np.newaxis])
y = np.ones(20)

# 训练数据集
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.33, random_state=7)

# 岭迹曲线计算
n_alphas = 200
alphas = np.logspace(-10, -2, n_alphas)

coefs = []
for alpha in alphas:
    ridge = linear_model.Ridge(alpha=alpha, fit_intercept=False)
    ridge.fit(X_train, y_train)
    coefs.append(ridge.coef_)

# 岭迹曲线展示
ax = plt.gca()

ax.plot(alphas, coefs)
ax.set_xscale('log')

# 通过这种方式可以局部设置字体（支持中文），不影响绘图其他部分
font = FontProperties(fname='C:\\Windows\\Fonts\\SimHei.ttf', size=16)

plt.xlabel('岭参数(alpha)', fontproperties=font)      # 超参数α
plt.ylabel('回归系数(weights)', fontproperties=font)  # 回归系数
plt.title('回归系数随岭参数α的变化', fontproperties=font)

plt.axis('tight')
plt.show()
 
