 
import numpy as np
from sklearn.svm import SVR
from matplotlib.font_manager import FontProperties
import matplotlib.pyplot as plt

# #############################################################################
# 生成样本数据：X为40行，1列，取值范围在[0,5)之间的均匀分布的随机样本值。
X = np.sort(5 * np.random.rand(40, 1), axis=0)
# 对X取正弦作为目标变量y，并降成一维数组。这样(X, y)
y = np.sin(X).ravel()

# #############################################################################
# 对目标变量y，附加噪音（随机误差）
y[::5] += 3 * (0.5 - np.random.rand(8))

# #############################################################################
# 拟合不同核函数的SVR模型
svr_rbf = SVR(kernel='rbf', C=100, gamma=0.1, epsilon=.1)
svr_lin = SVR(kernel='linear', C=100, gamma='auto')
svr_poly = SVR(kernel='poly', C=100, gamma='auto', degree=3, epsilon=.1, coef0=1)

# #############################################################################
# 绘制图形，显示结果
svrs = [svr_rbf, svr_lin, svr_poly]
kernel_label = ['RBF', 'Linear', 'Polynomial']
model_color = ['m', 'c', 'g']

# 获得一个字体对象
font = FontProperties(fname='C:\\Windows\\Fonts\\SimHei.ttf')  #, size=16)

fig, axes = plt.subplots(nrows=1, ncols=3, figsize=(15, 10), sharey=True)
fig.canvas.set_window_title('支持向量回归SVR')

for ix, svr in enumerate(svrs):
    axes[ix].plot(X, svr.fit(X, y).predict(X), color=model_color[ix], lw=2,
                  label='{} 模型'.format(kernel_label[ix]))
    axes[ix].scatter(X[svr.support_], y[svr.support_], facecolor="none",
                     edgecolor=model_color[ix], s=50,
                     label='{} 支持向量'.format(kernel_label[ix]))
    axes[ix].scatter(X[np.setdiff1d(np.arange(len(X)), svr.support_)],
                     y[np.setdiff1d(np.arange(len(X)), svr.support_)],
                     facecolor="none", edgecolor="k", s=50,
                     label='其他训练数据')
    axes[ix].legend(loc='upper center', bbox_to_anchor=(0.5, 1.1),
                    ncol=1, fancybox=True, shadow=True, prop=font)

fig.text(0.5, 0.04, 'X', ha='center', va='center')
fig.text(0.06, 0.5, 'y', ha='center', va='center', rotation='vertical')
fig.suptitle("支持向量回归", fontsize=18, fontproperties=font)
plt.show()
