 
import numpy as np
from sklearn.datasets import make_biclusters
from sklearn.cluster import SpectralCoclustering
from sklearn.metrics import consensus_score
from matplotlib import pyplot as plt
from matplotlib.font_manager import FontProperties

#1 使用make_biclusters()生成双聚类所需的样本数据集
data, rows, columns = make_biclusters(shape=(300, 300), n_clusters=5, noise=5,
    shuffle=False, random_state=0)


### 构建一个字体对象，以使pyplot支持中文
font = FontProperties(fname='C:\\Windows\\Fonts\\SimHei.ttf')  #, size=16)

fig = plt.figure(figsize=(10,8))
fig.canvas.set_window_title("谱联合聚类SpectralCoclustering")

#2 显示原始数据集
plt.subplot(2,2,1)
plt.matshow(data, cmap=plt.cm.Blues, fignum=False)
plt.title("原始数据集", y=1.1, fontproperties=font)

# 对原始数据集进行随机排序（洗牌）
rng = np.random.RandomState(0)
row_idx = rng.permutation(data.shape[0])
col_idx = rng.permutation(data.shape[1])
data = data[row_idx][:, col_idx]

#3 显示洗牌后的数据集
plt.subplot(2,2,2)
plt.matshow(data, cmap=plt.cm.Blues, fignum=False)
plt.title("对原始数据集进行随机排序", y=1.1, fontproperties=font)

#4 构建谱联合聚类对象，并拟合
model = SpectralCoclustering(n_clusters=5, random_state=0)
model.fit(data)

# 排序
fit_data = data[np.argsort(model.row_labels_)]
fit_data = fit_data[:, np.argsort(model.column_labels_)]

plt.subplot(2,1,2)
plt.matshow(fit_data, cmap=plt.cm.Blues, fignum=False)
plt.title("双聚类，并重新排序", y=1.1, color='b', fontproperties=font)

#5 最后显示
plt.tight_layout()
plt.show()
 
