 
import numpy as np
from sklearn.model_selection import train_test_split
from sklearn.linear_model import TweedieRegressor

n_samples, n_features = 1000, 20
rng = np.random.RandomState(0)

# 从标准正态分布中返回多个样本值（浮点数）
X = rng.randn(n_samples, n_features)

# 利用X，随机生成泊松数值（大于等于0的整数）
y = rng.poisson(lam=np.exp(X[:, 5]) / 2)

X_train, X_test, y_train, y_test = train_test_split(X, y, random_state=rng)
glm = TweedieRegressor(power=1, link='log') # 等同于使用PoissonRegressor()

glm.fit(X_train, y_train)
print(glm.score(X_test, y_test))
 
