 
import numpy as np
from sklearn.datasets import make_classification
from sklearn.model_selection import train_test_split
from sklearn.ensemble import AdaBoostClassifier
from sklearn.tree import DecisionTreeClassifier
import matplotlib.pyplot as plt
from matplotlib.font_manager import FontProperties

#1 生成分类数据
X, y = make_classification(n_samples=1000, n_features=20, n_informative=15, n_redundant=5, random_state=6)
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.33, random_state=42)

#2 创建一系列列集成模型对象（弱学习器的深度不同），待评估
# 定义一个词典models，存放 弱分类器名称：弱分类器对象
models = dict()

# 定义10个深度为 1, 2, 3, ..., 10 的决策树分类器（弱分类器）
for depth in range(1,11):
  # 定义弱分类器对象（基础模型）：决策树分类器
  base = DecisionTreeClassifier(max_depth=depth)

  # 定义Adaboost集成模型
  models[str(depth)] = AdaBoostClassifier(base_estimator=base)
# end of for ...

#3 构建集成模型，并获得评分
print("展示Adaboost算法中，超参数决策树深度对性能的影响。")
scores, depths = list(), list()
for name, model in models.items():
  clf = model.fit(X_train, y_train)
  score = clf.score(X_test, y_test)

  scores.append(score)
  depths.append(name)
  
  print("深度=%2s, 评分=%.5f" % (name, score))
#end of for ...

#4 绘制性能曲线
fig = plt.figure(figsize=(10,6))   # 设置当前figure的大小。
fig.canvas.manager.set_window_title("AdaBoostClassifier集成模型")  # Matplotlib >= 3.4
#fig.canvas.set_window_title("AdaBoostClassifier集成模型")  # Matplotlib < 3.4

font = FontProperties(fname="C:\\Windows\\Fonts\\SimHei.ttf")  # , size=16
plt.title("AdaBoostClassifier集成模型(决策树)", fontproperties=font)

plt.plot(depths, scores, "o-", color="g")
plt.xlabel("深度", fontproperties=font)
plt.ylabel("评分", fontproperties=font)
plt.show()
 