   
import numpy as np  
from sklearn.datasets import load_iris  
from sklearn.model_selection import train_test_split  
from sklearn.dummy import DummyClassifier  
from sklearn.svm import SVC  
  
X, y = load_iris(return_X_y=True)  
  
# 转换为二分类问题  
y[y != 1] = -1  
unique,count = np.unique(y,return_counts=True)  
print("原始数据集中目标变量分布情况：%s , %s" %(unique,count))  
print("-"*50)  
  
# 训练数据集与测试集的划分  
X_train, X_test, y_train, y_test = train_test_split(X, y, random_state=0)  
  
# 线性支持向量分类评估器 这里kernel、C均为超参数
lnr_clf = SVC(kernel='linear', C=1).fit(X_train, y_train)  
print("%27s %s" % ("支持向量分类(linear)评分：", lnr_clf.score(X_test, y_test)))  
print("-"*50)  
  
# 哑分类评估器  
dm_clf = DummyClassifier(strategy='most_frequent', random_state=0)  
dm_clf.fit(X_train, y_train)  
  
# 查看哑分类评估器的返回值。这里总是返回出现频率最大的类别值（-1）  
y = dm_clf.predict(X)  
unique,count = np.unique(y,return_counts=True)  
print("哑分类评估器预测的目标变量分布情况： %s , %s" %(unique,count))  

# 下面两条语句结果一样
#dm_score = dm_clf.score(None,  y_test)
dm_score = dm_clf.score(X_test, y_test)
print("%27s %s" % ("哑分类评估器评分：", dm_score))  
print("-"*50)  
  
# RBF支持向量分类评估器 这里kernel、C均为超参数
rbf_clf = SVC(kernel='rbf', C=1).fit(X_train, y_train)  
print("%27s %s" % ("支持向量分类(rbf)评分：", rbf_clf.score(X_test, y_test)))  
   