 
import pandas as pd
import numpy as np
from sklearn.covariance import EllipticEnvelope

# 创建拟合（训练）数据集
df = pd.DataFrame(np.array([[0,1], [1,1], [1,2], [2,2], [5,6]]), columns = ["x", "y"], index = [0,1,2,3,4])

# 并把数据集转变为Numpy数组格式
data = df[['x', 'y']].values

# 初始化一个椭圆包络线评估器对象
# 参数contamination定义了训练数据集中离群点所占的百分比
model1 = EllipticEnvelope(contamination = 0.1) 
# 拟合训练评估器，使之成为一个可以应用的模型
model1.fit(data)

# 构建一个新的数据集（用于预测使用）
new_data = np.array([[10,10], [1,1], [1,1], [1,1]])
# 预测新数据（预测结果中，-1表示为离群点，1为正常点
pred1 = model1.predict(new_data)

# 输出
print("新数据集：\n", new_data, "\n")
print("预测结果：\n", pred1)
 