 
import numpy as np
from sklearn.preprocessing import StandardScaler
from sklearn.datasets import load_iris
from sklearn.decomposition import FactorAnalysis, PCA
from matplotlib.font_manager import FontProperties
import matplotlib.pyplot as plt

# 以鸢尾花数据集为示例
data = load_iris()
X = StandardScaler().fit_transform(data["data"])
feature_names = data["feature_names"]

n_comps = 2  # 主成分分析PCA的主成分为2，因子分析因子数量也为2 
methods = [
    ("主成分分析PCA", PCA()),
    ("无旋转因子分析FA", FactorAnalysis()),
    ("Varimax旋转因子分析FA", FactorAnalysis(rotation="varimax")),
]

# 设置画布信息
fig, axes = plt.subplots(ncols=len(methods), figsize=(8, 5))
fig.canvas.manager.set_window_title("因子分析示例（鸢尾花数据集）")  # Matplotlib >= 3.4  
#fig.canvas.set_window_title("因子分析示例（鸢尾花数据集）")         # Matplotlib < 3.4
#声明一个字体对象，后面绘图使用  
font = FontProperties(fname="C:\\Windows\\Fonts\\SimHei.ttf")  # , size=16

# 提取主成分/因子，并可视化展示
for ax, (method, fa) in zip(axes, methods):
  fa.set_params(n_components=n_comps)
  fa.fit(X)

  components = fa.components_.T
  print("\n\n %s :" % method)
  print(components)

  vmax = np.abs(components).max()
  ax.imshow(components, cmap="RdBu_r", vmax=vmax, vmin=-vmax)  # 热力图
  ax.set_yticks(np.arange(len(feature_names)))
  if ax.get_subplotspec().is_first_col():  #ax.is_first_col()已经过时
    ax.set_yticklabels(feature_names)
  else:
    ax.set_yticklabels([])

  ax.set_title(str(method), fontproperties=font)
  ax.set_xticks([0, 1])
  if(method==methods[0][0]):       # "主成分分析PCA"
    ax.set_xticklabels(["主成分1", "主成分2"], fontproperties=font)
  else:
    ax.set_xticklabels(["因子1", "因子2"], fontproperties=font)

# 显示
fig.suptitle("主成分/因子", fontproperties=font)
plt.tight_layout()
plt.show()
 
