 
import numpy as np
from sklearn.decomposition import FastICA
from unittest import TestCase

# 随机构建训练数据集，100个样本，10个特征变量
rng = np.random.RandomState(0)
X = rng.random_sample((100, 10))

# 声明一个TestCase对象
tc = TestCase()

# 以两种情形测试FastICA()的应用：独立成分数量、是否白化
for whiten, n_components in [[True, 5], [False, None]]:
  n_components_ = (n_components if n_components is not None else X.shape[1])

  #1 声明对象，训练并转换数据（获取独立成分）
  # fit_transform(X)
  ica = FastICA(n_components=n_components, whiten=whiten, random_state=0)
  Xt1 = ica.fit_transform(X)

  # 
  tc.assertEqual(ica.components_.shape, (n_components_, 10))
  tc.assertEqual(Xt1.shape, (100, n_components_))

  #2 声明对象，训练，然后转换数据（获取独立成分）
  # fit(X) -->transform(X)
  ica = FastICA(n_components=n_components, whiten=whiten, random_state=0)
  ica.fit(X)
  tc.assertEqual(ica.components_.shape, (n_components_, 10))
  Xt2 = ica.transform(X)

  # 这两种使用方式结果是否基本相同
  retAssert = np.testing.assert_array_almost_equal(Xt1, Xt2)
  if(retAssert is None):
    print("fit_transform() 与 fit()-->transform()结果是一致的......")

# end of for ...
 
