 
import numpy as np
from sklearn.pipeline import FeatureUnion
from sklearn.datasets import load_iris
from sklearn.model_selection import train_test_split
from sklearn.decomposition import PCA
from sklearn.feature_selection import SelectKBest
from sklearn.svm import SVC


# 加载鸢尾花数据集
X, y = load_iris(return_X_y=True)

# 对完整数据集进行划分：训练集和测试集
X_train, X_test, y_train, y_test = train_test_split(X, y, stratify=y, random_state=42)

# 声明一个主成分分析PCA对象
pca = PCA(n_components=2)

# 声明一个SelectKBest对象
# 这里k=1，选择最好的前k个特征变量
selection = SelectKBest(k=1)

# 构建特征聚合转换器对象
combined_features = FeatureUnion([("pca", pca), ("selected", selection)])

# 使用X_train, y_train训练特征聚合转换器对象
cmbnd = combined_features.fit(X_train, y_train)

# 对X_train进行转换，以便用于其他模型，如支持向量分类机 SVC
# 基于X_train的新聚合后的训练数据集
X_train_fu = cmbnd.transform(X_train)
print("聚合后特征变量空间有", X_train_fu.shape[1], "个特征变量。\n")
print("-"*37)

# 使用聚合后的新数据集，训练SVC对象
svm = SVC(kernel="linear")
svm.fit(X_train_fu, y_train)

# 先对X_test进行聚合，然后预测结果
X_fu_test = cmbnd.transform(X_test)
result = svm.predict(X_fu_test)
print("预测类别值为:\n", result) # 输出结果，以便于真实的结果对比

# 输出真实的结果，以便对照
print("真实类别值为:\n", y_test)
 
