 
import numpy as np
from sklearn.neighbors import LocalOutlierFactor


# 构造数据集
X0 = [ [1,1], [4,1], [2,2],[1,6], [4,3]]
X = np.array(X0)  # 转变为Numpy数组

# 本例中设置k=2 （n_neighbors）
clf = LocalOutlierFactor(n_neighbors=2, metric="manhattan")

# fit_predict()返回为1表示为正常点，-1表示为离群点
is_inlier = clf.fit_predict(X)
numOfOutlier = np.sum(is_inlier==-1)
print("离群点个数：%d个" % numOfOutlier)
print("-"*21)  

for i, flag in enumerate(is_inlier):
  if flag==1 :
    print("第%d个数据点是正常点" % (i+1))
  else :
    print("第%d个数据点是离群点" % (i+1))

print("-"*37)

# 也可以是用属性 negative_outlier_factor_  判断异常点
# 值越大，说明对应的数据点越有可能为正常点。
# 也就是，值越小，越有可能是离群点
scores = clf.negative_outlier_factor_
for i, score in enumerate(scores):
  print("第%d个数据点的负LOF是%f" % (i+1, score))
 
