 
import numpy as np
from sklearn.decomposition import NMF

# 构建原始非负矩阵（数据集）
# 例如：X代表两个文档中的加权词频向量.一列代表一个文档
# X的形状shape为(6,2)，两个文档，每个文档6个词
X = np.array([[1, 1], [2, 1], [3, 1.2], [4, 1], [5, 0.8], [6, 1]])

# 构建NMF模型
model = NMF(n_components=2, init='random', random_state=0)

# 拟合模型，并得到转换矩阵W
W = model.fit_transform(X)

# 获得成分矩阵H
H = model.components_

# 分布输出转换矩阵W和成分矩阵H
print("转换矩阵W：")
print(W)
print("-"*37)
print("成分矩阵H：")
print(H)
print()

print("="*37)
print("转换矩阵W与成分矩阵H的乘积：")
print(W@H)
print("原始数据集（矩阵）X：")
print(X)
 
