 
from sklearn.svm import OneClassSVM
from sklearn.datasets import make_blobs
from numpy import quantile, where, random
from matplotlib.font_manager import FontProperties
import matplotlib.pyplot as plt


#0.1 生成用于聚类的具有各向同性的、符合高斯分布的数据集
random.seed(13)
#   两个特征变量，centers=1，即数据集包含的类别数
x, _ = make_blobs(n_samples=200, n_features=2, centers=1, cluster_std=.3, center_box=(8, 8))

#0.2 初始化画布
fig = plt.figure(figsize=(12, 6))
fig.canvas.manager.set_window_title("OneClassSVM异常检测")  # Matplotlib >= 3.4
#fig.canvas.set_window_title("OneClassSVM异常检测")         # Matplotlib < 3.4

#0.3 声明一个字体对象，后面绘图使用
font = FontProperties(fname="C:\\Windows\\Fonts\\SimHei.ttf")  # , size=16

# 下面是两种进行异常检测的方式
#1 方法1：使用预测方法predict()进行异常点检测
#1.1 定义OneClassSVM()对象
svm = OneClassSVM(kernel='rbf', gamma=0.001, nu=0.03)

#1.2 拟合模型，并进行预测
svm.fit(x)
pred = svm.predict(x)

#1.3 过滤出预测值为-1的样本点（为异常值，外点）
anom_index = where(pred==-1)
anom_values_1 = x[anom_index]

#1.4 可视化异常点，并把异常点使用红色显示
plt.subplot(1, 2, 1)  # 1行，两列，当前为第 1 个Axes
plt.scatter(x[:,0], x[:,1])
plt.scatter(anom_values_1[:,0], anom_values_1[:,1], color='r')
plt.title("predict()方法", fontproperties=font)

#2 方法2：使用评分函数score_samples进行异常点检测
#2.1 定义OneClassSVM()对象。为了对比，使用与第一种方法相同的参数
svm = OneClassSVM(kernel='rbf', gamma=0.001, nu=0.03)

#2.2 拟合模型，并计算样本的评分
pred = svm.fit_predict(x)
scores = svm.score_samples(x)

#2.3 使用分位数函数获得一个阈值。本例中使用最低的4%分数值为阈值
#    也就是说，低于这个分位数值的样本点为异常点
threshold = quantile(scores, 0.04)

#2.4 分数与阈值比较，获得异常点
anom_index = where(scores<=threshold)
anom_values_2 = x[anom_index]

#2.5 可视化异常点，并把异常点使用红色显示
plt.subplot(1, 2, 2)  # 1行，两列，当前为第 2 个Axes
plt.scatter(x[:,0], x[:,1])
plt.scatter(anom_values_2[:,0], anom_values_2[:,1], color='r')
plt.title("score_samples方法(阈值%.4f)" % (threshold), fontproperties=font)

#3 最后可视化显示
plt.show()
 