 
import numpy as np
from sklearn import datasets  
 
iris = datasets.load_iris()
iris_X = iris.data
#print(iris_X.shape)  # (150, 4)

iris_y = iris.target
#print(iris_y.shape)  # (150,)  这是一维数据！

feature_names = iris.feature_names
iris_names    = np.append(feature_names, "target")
#print(iris_names)  # 


# 特征变量的量级对PCA有很大影响，所以首先需要标准化
# 这里使用StandardScaler()标准化
from sklearn.preprocessing import StandardScaler

# 对数据集中的特征变量进行标准化（均值为0，方差为1）
X = StandardScaler().fit_transform(iris_X)

from sklearn.decomposition import PCA

# 选择两个主成分
pca = PCA(n_components=2)

principalComponents = pca.fit_transform(X)
print("方差解释的情况：")
print(pca.explained_variance_ratio_)
varianceExplained = np.sum(pca.explained_variance_ratio_)
print("方差解释比率：%.2f%%" % (varianceExplained*100))

# 一维变成二维数据，以便在维度上与X保持一致
y = np.reshape(iris_y,(X.shape[0],1))
#print(y.shape)  #(150,1)  二维数据

# 构建新的数据集（包含了目标变量）
iris_new = np.concatenate([principalComponents, y],axis=1)
#print(iris_new.shape)

#可以把新的数据集应用到其他地方
#例如构建一个分类模型
#这里，我们把新数据集可视化展示


from matplotlib.font_manager import FontProperties  
import matplotlib.pyplot as plt


#初始化画布  
fig = plt.figure(figsize=(6, 6))  
fig.canvas.manager.set_window_title("PCA示例")  # Matplotlib >= 3.4  
#fig.canvas.set_window_title("PCA示例")         # Matplotlib < 3.4

#声明一个字体对象，后面绘图使用  
font = FontProperties(fname="C:\\Windows\\Fonts\\SimHei.ttf")  # , size=16


#可视化异常点，并把异常点使用红色显示
plt.subplot(1, 1, 1)  # 1行，1列，当前为第 1 个Axes
plt.title("PCA可视化", fontproperties=font)

'''
# 获取类别0,1,2的样本索引
index0 = (iris_new[:,2]==0)
index1 = (iris_new[:,2]==1)
index2 = (iris_new[:,2]==2)

# 第一个类别（0）以红色圆点展示
plt.scatter(iris_new[index0,0], iris_new[index0,1], c = 'r', s = 50, label='类别0')
# 第二个类别（1）以绿色圆点展示
plt.scatter(iris_new[index1,0], iris_new[index1,1], c = 'g', s = 50, label='类别1')
# 第三个类别（2）以蓝色圆点展示
plt.scatter(iris_new[index2,0], iris_new[index2,1], c = 'b', s = 50, label='类别2')
'''
# 下面这种方式更通用一些
targets = [0, 1, 2]
colors = ['r', 'g', 'b']
for target, color in zip(targets,colors):
    indicesToKeep = (iris_new[:,2] == target)  # True/False
    labelTxt = "类别" + str(target)
    plt.scatter( iris_new[indicesToKeep,0]
               , iris_new[indicesToKeep,1]
               , c = color, s = 50, label = labelTxt)


# 设置X、Y轴标签文字
plt.xlabel('第一个主成分', fontproperties=font)  
plt.ylabel('第二个主成分', fontproperties=font)

# 设置图例文字
plt.legend(loc='lower right', prop=font)  


# 显示
plt.show()
 

 

