   
from sklearn.datasets import make_classification
from sklearn.model_selection import train_test_split
from sklearn.feature_selection import SelectKBest
from sklearn.preprocessing import StandardScaler
from sklearn.linear_model import LogisticRegression
from sklearn.feature_selection import f_classif
from sklearn.pipeline import Pipeline
  
  
#0 随机生成一个具有两个标签的分类数据集。
# make_classification()默认特征数量n_features取默认值20个。
X, y = make_classification(n_samples = 50500, n_classes=3, n_informative=5, random_state=42)
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.33, random_state=42)

#1 特征选择-->特征标准化-->逻辑回归（分类）
out_filter = SelectKBest(f_classif, k=5)  # 特征选择，初始选择得分最高的前5个特征
std_Scale    = StandardScaler()
clf_log      = LogisticRegression()  # 参数solver、penalty采用默认值
  
#2  构造管道Pipeline对象，  
#   构造函数接受形式为 (评估器名称，评估器对象) 元组tuple的列表  
clfPipeline = Pipeline( [('anova', out_filter), ('scale', std_Scale), ('logReg', clf_log)] )
 
# 可以使用管道对象的set_params()函数设置某个步骤的参数。  ···
# 例如，设置out_filter的特征选择个数参数 k=10，logReg的正则化参数penalty='l1'  
# 然后调用fit()方法，对管道（评估器）进行拟合训练。注意：  
# anova__k        设置了第一个转换器 out_filter 的参数，因为其名称为“anova”
#      而k为转换器SelectKBest()的参数k，表示返回几个特征变量
# logReg__solver  设置了第三个评估器 clf_log 的参数，因为其名称为“logReg” ，
#       而solver为逻辑回归评估器LogisticRegression()的求解优化器参数。
# logReg__penalty 设置了第三个评估器 clf_log 的参数，因为其名称为“logReg”，
#       而penalty为逻辑回归评估器LogisticRegression()的惩罚项参数，表示正则化项的类别。
clfPipeline.set_params(anova__k=10, logReg__solver='liblinear', logReg__penalty='l1')
# 拟合模型（训练模型）
clfPipeline.fit(X_train, y_train)


# 使用管道的predict()进行预测  
prediction = clfPipeline.predict(X_test)
#print(prediction)  
  
# 使用管道的score()计算分数。  
tmpScore = clfPipeline.score(X_test, y_test)
print(tmpScore)
print("-"*37)
  
  
# 获取out_filter选择的特征  
aFeatures = clfPipeline['anova'].get_support()
print(aFeatures)
  
# 另外一种办法是，获取out_filter选择的特征  
#print(clfPipeline.named_steps.anova.get_support())  
