   
from sklearn import datasets
from sklearn.model_selection import train_test_split
from sklearn.model_selection import RandomizedSearchCV
from sklearn.metrics import classification_report
from sklearn.svm import SVC
  
# 导入系统自带的手写数字图片数据集  
digits = datasets.load_digits()
  
# 转换原始数据为(samples, feature)形式，便于使用分类模型  
n_samples = len(digits.images)
X = digits.images.reshape((n_samples, -1))
y = digits.target
  
# 把数据集划分为训练数据集和测试数据集  
X_train, X_test, y_train, y_test = train_test_split(
    X, y, test_size=0.5, random_state=0)
  
# 设置超参数组合，以适应交叉验证  
tuned_parameters = [{'kernel': ['rbf'], 'gamma': [1e-3, 1e-4], 
                     'C': [1, 10, 100, 1000]},  
                    {'kernel': ['linear'], 'C': [1, 10, 100, 1000]}]  
scores = ['precision', 'recall']
  
for score in scores:
    print("## 度量指标（%s）下的超参数寻优：" % score)
    print("--"*25)  
  
    # 默认 refit = True，表示获得最佳超参数后，在整个数据集上重新拟合模型  
    # 默认 cv = 5，表示使用5折交叉验证  
    clf = RandomizedSearchCV( SVC(), tuned_parameters, scoring='%s_macro' % score )
    clf.fit(X_train, y_train)  # 必须的一步
  
    print("基于训练数据集，搜索到的最佳超参数组合是：")
    print(clf.best_params_)
    print()
  
    print("基于训练数据集的交叉验证，网格评分如下：")
    means = clf.cv_results_['mean_test_score']
    stds  = clf.cv_results_['std_test_score' ]
    # zip()函数可将列表对象中对应的元素打包成一个个元组，然后返回由这些元组组成的列表。  
    for mean, std, params in zip(means, stds, clf.cv_results_['params']):
        print("%0.3f (+/-%0.03f) for %r" % (mean, std * 2, params))
    print()
  
    print("下面列出详细的分类报告（基于测试数据集）：")
    y_true, y_pred = y_test, clf.predict(X_test)
    print(classification_report(y_true, y_pred))
    print()
 # end of for loop
  