 
import sklearn
from sklearn.linear_model import LogisticRegression
from sklearn import set_config

#0 输出所有信息
set_config(print_changed_only=False)

#1 算法LogisticRegression()的默认设置如下：
#LogisticRegression(penalty='l2', *, dual=False, tol=0.0001, C=1.0, fit_intercept=True,
#                   intercept_scaling=1, class_weight=None, random_state=None,
#                   solver='lbfgs', max_iter=100, multi_class='auto', verbose=0,
#                   warm_start=False, n_jobs=None, l1_ratio=None)[source]

#2 改变一个参数值
lr = LogisticRegression(penalty="l1", max_iter=100)

print("由于print_changed_only=False，故输出所有信息:")
print(lr)
print("-"*37)

#3 只输出修改过的参数
set_config(print_changed_only=True)

print("由于print_changed_only=True，仅输出修改过的信息:")
print(lr)
print("-"*37)


#4 上下文环境示例
from sklearn.utils.validation import assert_all_finite

with sklearn.config_context(assume_finite=True):
    print("假定数据值都在有效范围内，则不再核查。")
    assert_all_finite([float('nan')])   # 数据不在有效范围内，但不会引发异常
    print("OK.......\n")

with sklearn.config_context(assume_finite=True):
    with sklearn.config_context(assume_finite=False):
        print("不再假定数据值都在有效范围内，则核查所有值。")
        assert_all_finite([float('nan')])   # 数据不在有效范围内，引起异常发生
        print("NOT ok.......")  # 不会运行到这一行...
 
