 
from sklearn.datasets import load_iris
from sklearn.ensemble import RandomForestClassifier, StackingClassifier
from sklearn.linear_model import LogisticRegression
from sklearn.model_selection import train_test_split
from sklearn.neighbors import KNeighborsClassifier
from sklearn.tree import DecisionTreeClassifier

# 加载鸢尾花数据集
X, y = load_iris(return_X_y=True)

# 对完整数据集进行划分：训练集和测试集
X_train, X_test, y_train, y_test = train_test_split(X, y, stratify=y, random_state=42)


# 构建 第一层 基本评估器
rndForest1 = RandomForestClassifier(n_estimators=10, random_state=42)
knn1 = KNeighborsClassifier(n_neighbors=5)
layer_one_estimators = [
                        ('rf_1', rndForest1),
                        ('knn_1',knn1 )             
                       ]

# 构建 第二层 基本评估器
dt2 = DecisionTreeClassifier()
rndForest2 = RandomForestClassifier(n_estimators=50, random_state=42)
layer_two_estimators = [
                        ('dt_2', dt2),
                        ('rf_2', rndForest2),
                       ]

# 待嵌入的堆栈泛化模型，即构建第二层堆栈泛化模型所需要的元评估器
layer_two_final = StackingClassifier(estimators=layer_two_estimators, final_estimator=LogisticRegression())

# 构建最终的堆栈泛化模型
fnlClf = StackingClassifier(estimators=layer_one_estimators, final_estimator=layer_two_final)

# 训练最终的堆栈泛化模型
fnlClf.fit(X_train, y_train)

# 计算准确率
scores = fnlClf.score(X_test, y_test)
print("二级堆栈泛化精度：%0.3f" % scores)
 
