 
import numpy as np
from sklearn.svm import SVC
from sklearn.datasets import load_digits
from sklearn.model_selection import validation_curve
from matplotlib.font_manager import FontProperties
import matplotlib.pyplot as plt

# 导入系统自带的手写数字特征向量数据集
X, y = load_digits(return_X_y=True)

# 构造 validation_curve() 的参数
param_range = np.logspace(-6, -1, 5)
print(param_range)
# 交叉验证参数cv默认为5，表示划分5组
train_scores, test_scores = validation_curve(
      SVC(), X, y, param_name="gamma", param_range=param_range,
      scoring="accuracy", n_jobs=1)

train_scores_mean = np.mean(train_scores, axis=1)
train_scores_std = np.std(train_scores, axis=1)
test_scores_mean = np.mean(test_scores, axis=1)
test_scores_std = np.std(test_scores, axis=1)

# 绘制图形
fig = plt.figure(figsize=(10,6))   # 设置当前figure的大小。
fig.canvas.manager.set_window_title("交叉验证曲线")  # Matplotlib >= 3.4
#fig.canvas.set_window_title("交叉验证曲线")  # Matplotlib < 3.4

### 构建一个字体对象，以使 matplotlib.pyplot 支持中文
font = FontProperties(fname='C:\\Windows\\Fonts\\SimHei.ttf', size=12)

plt.title("模型SVM交叉验证曲线", fontproperties=font)
plt.xlabel(r"$\gamma$")
plt.ylabel("评分", fontproperties=font)
plt.ylim(0.0, 1.1)

plt.semilogx(param_range, train_scores_mean, label="训练评分",
             color="darkorange", lw=2)
plt.fill_between(param_range, train_scores_mean - train_scores_std,
                 train_scores_mean + train_scores_std, alpha=0.2,
                 color="darkorange", lw=2)

plt.semilogx(param_range, test_scores_mean, label="交叉验证评分",
             color="navy", lw=2)
plt.fill_between(param_range, test_scores_mean - test_scores_std,
                 test_scores_mean + test_scores_std, alpha=0.2,
                 color="navy", lw=2)

# 使图例(legend)支持中文
plt.legend(loc='best',fancybox=True, shadow=True, prop=font)

plt.show()
 