 
from sklearn.datasets import load_iris
from sklearn.neighbors import KNeighborsClassifier
from sklearn.model_selection import cross_val_score
from matplotlib.font_manager import FontProperties
import matplotlib.pyplot as plt

X, y = load_iris(return_X_y=True)

# 交叉验证对参数进行选择
k_range = range(1,31)
k_accuracy = []
for k in k_range:   # 轮询设置参数 n_neighbors
    knn = KNeighborsClassifier(n_neighbors=k)   # 以 k 为最近邻个数，构建KNN模型
    
    accuracy = cross_val_score(knn, X, y, cv=10, scoring='accuracy')  # 分类准确度
    k_accuracy.append(accuracy.mean())   # 把平均值加入列表对象

# 寻找最好的 K（超参数）
accuracy_Max = max(k_accuracy)

# 获取第一个等于最好准确率的 K 值 索引
#iIndex = k_accuracy.index(accuracy_Max)
# 获取所有等于最好准确率的 K 值 索引
iIndexes = [idx for idx, x in enumerate(k_accuracy) if x==accuracy_Max]

# 获取所有等于最好准确率的 K 值
bestK  = [ k_range[idx] for idx in iIndexes ]
# 构建KNeighborsClassifier模型时，就可以设置n_neighbors=bestK[]
# 此处略

# 绘制K值与准确率之间的关系图
fig = plt.figure(figsize=(8,6))   # 设置当前figure的大小。
fig.canvas.manager.set_window_title("交叉验证示例")  # Matplotlib >= 3.4
#fig.canvas.set_window_title("交叉验证实例")  # Matplotlib < 3.4

### 构建一个字体对象，以使 matplotlib.pyplot 支持中文
font = FontProperties(fname='C:\\Windows\\Fonts\\SimHei.ttf', size=12)

plt.plot(k_range, k_accuracy)  # 在当前子图中绘制执折线
plt.title("K值与交叉验证准确度关系(最佳K=" +str(bestK)+")", fontproperties=font)
plt.xlabel("KNN算法的K值", fontproperties=font)
plt.ylabel("交叉验证准确度", fontproperties=font)

plt.show()
 