
from sklearn.model_selection import cross_val_score
from sklearn.model_selection import ShuffleSplit
from sklearn.datasets import load_iris
from sklearn import svm

# 构建分类评估器
clf = svm.SVC(kernel='linear', C=1, random_state=42)

# 导入系统自带的鸢尾花数据集
iris = load_iris()
X = iris.data
y = iris.target

# 调用cross_val_score() ，注意cv=5。使用KFold()
#scores = cross_val_score(clf, X, y, cv=5, scoring='f1_macro')
# 这里使用一个随机排列交叉验证器ShuffleSplit()对象
cvSfl = ShuffleSplit(n_splits=5, test_size=0.3, random_state=0)
scores = cross_val_score(clf, X, y, cv=cvSfl, scoring='f1_macro')

print(scores)

# 输出每次划分对应的模型指标
for index, score in enumerate(scores):    
  print ("第 %s 个分数：%.5s" % (index + 1, score))

# 评价得分以及得分的标准差计算如下
print("-"*37)
print("平均准确率：%0.2f，标准差：%0.5f" % (scores.mean(), scores.std()))
 