 
from sklearn import datasets, linear_model
from sklearn.model_selection import cross_validate

# 导入系统自带的糖尿病数据集，构建Lasso线性回归模型
diabetes = datasets.load_diabetes()
X = diabetes.data[:150]
y = diabetes.target[:150]
lasso = linear_model.Lasso()

# 应用交叉验证，获取不同指标数据
#1 scoring使用默认值None，表示使用lasso模型的默认score()函数。
# 这将返回一个指标，这里是线性回归的决定系数（拟合优度）R2
print("参数scoring设置为默认值，且交叉验证设置为3组。")
cv_result1 = cross_validate(lasso, X, y, cv=3)

# 输出返回结果
for key ,value in cv_result1.items():
  print("%28s : %.128s" %(key, value))
print("- "*33, "\n")

#2 这里设置参数scoring为多个指标的情况
print("参数scoring设置计算多个指标，且交叉验证设置为4组。")
cv_result2 = cross_validate(lasso, X, y, cv=4,
             scoring=('r2', 'neg_mean_squared_error'),
             return_train_score=True)

# 输出返回结果
for key ,value in cv_result2.items():
  print("%28s : %.128s" %(key, value))
print("- "*33)
 