 
from sklearn.datasets import load_iris
from sklearn import svm
from sklearn.model_selection import ShuffleSplit
from sklearn.metrics import make_scorer
from sklearn.metrics import roc_auc_score
from sklearn.model_selection import cross_validate

# 导入系统自带的鸢尾花数据集(多分类问题)  
X, y = load_iris(return_X_y=True)

# 构建分类评估器
clf = svm.SVC(kernel='linear', C=1, probability=True, random_state=42)

# 构建一个随机排列交叉验证器ShuffleSplit()对象
cvSfl = ShuffleSplit(n_splits=5, test_size=0.3, random_state=0)

# 使用make_scorer()构建评分器
roc_Scorer = make_scorer(roc_auc_score, needs_proba=True, multi_class='ovo')
# 可以同时使用多个度量指标
myScore = {'myF1': 'f1_macro', 'myRoc':roc_Scorer}

# 交叉验证：返回结果为一个词典对象
scores = cross_validate(clf, X, y, cv=cvSfl, return_train_score=True, scoring=myScore)

# 输出每次划分对应的模型指标
print ("%s %6s, %s" % ("No.", "指标名称", "指标值"))
print("-"*74)
for index, scoreName in enumerate(scores):
  print ("%s %12s, %s" % (index + 1, scoreName, scores[scoreName]))
print("-"*74)
 