 
import numpy as np
from sklearn.model_selection import ShuffleSplit
from sklearn.metrics import make_scorer
from sklearn.model_selection import cross_validate
from sklearn.datasets import load_diabetes
from sklearn.linear_model import LinearRegression

# 一个自定义函数，其中kwargs表示其它额外的任何参数
def my_custom_loss_func(y_true, y_pred, **kwargs):
  diff = np.abs(y_true - y_pred).max()
  return np.log1p(diff)

# 导入系统自带的糖尿病数据集(回归问题)  
X, y = load_diabetes(return_X_y=True)

# my_score实际上是一个可以调用的函数
my_score = make_scorer(my_custom_loss_func, greater_is_better=False)

# 构建回归评估器
regr = LinearRegression()

# 构建一个随机排列交叉验证器ShuffleSplit()对象
cvSfl = ShuffleSplit(n_splits=5, test_size=0.3, random_state=0)

# 交叉验证：返回结果为一个词典对象
scores = cross_validate(regr, X, y, cv=cvSfl, return_train_score=True, 
                        scoring=my_score)

# 输出每次划分对应的模型指标
print ("%s %6s, %s" % ("No.", "指标名称", "指标值"))
print("-"*74)
for index, scoreName in enumerate(scores):
  print ("%s %12s, %s" % (index + 1, scoreName, scores[scoreName]))
print("-"*74)

# 可以直接使用评分器my_score()
#regr.fit(X,y)
#print(my_score(regr,X,y))
 