 
from sklearn import svm
from sklearn import datasets

# 训练一个SVC()模型
clf = svm.SVC()
X, y= datasets.load_iris(return_X_y=True)
clf.fit(X, y) # 训练模型

# 导入pickle
import pickle

# 1 保存为Pyhon对象
# 使用模块pickle的dumps()方法导出（保存）模型
# pickling
model = pickle.dumps(clf)

# ....

# 使用模块pickle的loads()方法加载模型
# unpickling
clf2 = pickle.loads(model)

# 应用模型
y0 = clf2.predict(X[0:1])
print("预测结果", y0)

print("-"*37)

# 2 保存为文件
# 获取持久化模型（保存）的文件对象。
try:
  outFile = open("E:\\MODLES\\SVC_Model.clf", mode ="wb")

  # 使用模块pickle的dump()方法导出（保存）模型
  # pickling
  pickle.dump( clf, outFile )

except Exception as e:
  # 处理错误过程
  print('Error:',e)
finally:
  if outFile:
    outFile.close() # 真正保存模型与文件中


# 使用模块pickle的loads()方法加载模型
# unpickling
try:
  inFile = open("E:\\MODLES\\SVC_Model.clf", mode ="rb")

  # 使用模块pickle的load()方法加载模型
  # unpickling
  clf3 = pickle.load(inFile)

except Exception as e:
  # 处理错误过程
  print('Error:',e)
finally:
  if inFile:
    inFile.close() # 真正保存模型与文件中
    
# 应用模型
y0 = clf3.predict(X[0:1])
print("预测结果", y0)
 
